#include "StratusGenerator.h"
#include "CloudScene.h"

StratusGenerator::StratusGenerator(void)
{
	m_category = CloudScene::CT_Stratus;

	
}


StratusGenerator::~StratusGenerator(void)
{
}


void StratusGenerator::Initialize()
{

#if 1
	osg::Vec3 jitter_sizes(1000.f, 1000.f, 1000.f);
	float multiplikator = 5.f;
	osg::Vec3 sizes = osg::Vec3(3, 3, 3);
	osg::Vec3 randVer = m_middlepoint;
	
	int XM = 5;
	int YM = 5;
	int ZM = 3;
	
	int num_boxes=0;

	for(int z = 0; z < 2; z++)
	{
		for(int y = -3; y < 3; y++)
		{
			for(int x = -3; x < 4; x++)
			{
				//if((y != 0 && y != (YM-1) && x < 2 && x > (XM-3)) || (rand() % (z+1)) <= 1)
				if((rand() % 3) <= 1)
				{
					osg::Vec3 posHelper = randVer + osg::Vec3(x*500.f, y*500.f, z*500.f);

					osg::Vec3 size = osg::Vec3( 250.f*(0.5f+frand()*0.5f),
												250.f*(0.5f+frand()*0.5f),
												250.f*(0.5f+frand()*0.5f));

					
					AddCloudBox(num_boxes, posHelper, sizes, size, size, false, 500.f, osg::Vec4(5.f, 20.f, 5.f, 20.f), 0.9f);
					num_boxes++;
					AddBox(dBoxes_vertices, posHelper, size);
				}
			}
		}
	}
	std::cout << "Stratus created" << std::endl;
	
	EliminateRedudantSprites();
	
	dBoxes_indices.resize(dBoxes_vertices->size());
	for(unsigned int i = 0; i < dBoxes_vertices->size(); i++)	
		dBoxes_indices[i] = i;
	
	dBoxes_geometry->setVertexArray (dBoxes_vertices.get());
	dBoxes_geometry->addPrimitiveSet(
		new osg::DrawElementsUShort(osg::PrimitiveSet::TRIANGLES, dBoxes_vertices->size(), &dBoxes_indices[0])
	);
	dBoxes_geometry->getPrimitiveSet(0)->getDrawElements()->setDataVariance(osg::Object::STATIC);
	dBoxes->addDrawable(dBoxes_geometry.get());
	dBoxes->getOrCreateStateSet()->setMode(GL_CULL_FACE, osg::StateAttribute::OFF );
	dBoxes->setCullingActive(false);
	//dBoxes->getOrCreateStateSet()->setMode(GL_FRONT_AND_BACK, osg::PolygonMode::LINE );
#else
	m_cloud->dBoxes = (new osg::Geode());
	osg::ref_ptr<osg::Geometry> dBoxes_geometry (new osg::Geometry());
	m_cloud->dBoxes_vertices = new osg::Vec3Array();


	osg::ref_ptr<osg::Geode> geode (new osg::Geode());
	
	//osg::Vec3 jitter_sizes = osg::Vec3(2.0f,2.0f,2.0f);
	osg::Vec3 jitter_sizes = osg::Vec3(3.0f,3.0f,3.0f);

	float multiplikator = 2.f;
	//osg::Vec3 randVer = osg::Vec3((float)(400*(CloudGenerator::numClouds%5))+((frand()-0.5)*100.f), (float)(frand()*400*(CloudGenerator::numClouds/5)) +((frand()-0.5)*400.f), frand()*200.f+450.f);
	osg::Vec3 randVer = osg::Vec3((float)(800*(CloudGenerator::numClouds%8))+((frand()-0.5)*500.f)-1500.f, (float)(frand()*1000*(CloudGenerator::numClouds/8)) +((frand()-0.5)*400.f)-1500.f, frand()*200.f+450.f);
	randVer.x() *= multiplikator;
	randVer.y() *= multiplikator;
	randVer.z() *= multiplikator;
	//osg::Vec3 randVer = osg::Vec3();	

	//Stratus
	osg::Vec3 sizes = osg::Vec3(10,10,1);
	//AddCloudBox(0, randVer + osg::Vec3( -60.0f*multiplikator, 0.f, 0.0f), sizes, osg::Vec3(54.5f*multiplikator,120.5f*multiplikator,6.5f*multiplikator), jitter_sizes, true, 3000.f, osg::Vec4(10.f, 1000.f, 10.f, 1000.f));
	
	osg::Vec3 size =  osg::Vec3(54.5f*multiplikator,120.5f*multiplikator,6.5f*multiplikator);
	//AddCloudBox(0, randVer, sizes, size , jitter_sizes, true, 750.f, osg::Vec4(100.f, 200.f, 100.f, 200.f));
	AddCloudBox(0, randVer, sizes, size, jitter_sizes, false, 750.f, osg::Vec4(100.f, 200.f, 100.f, 200.f));
	AddBox(m_cloud->dBoxes_vertices, randVer, size);
	EliminateRedudantSprites();
	
	/*std::cout << "______________" << std::endl;
	std::cout << "EXPORT CLOUDS" << std::endl;
	
	ex->AddCloud(vertices, rotation, center, ids, box_centers, diffuselight_h, diffuselight_t, ambientlight_color, 6);
	ex->Perform();	

	std::cout << "______________" << std::endl;
	std::cout << "IMPORT CLOUDS" << std::endl;
	ImportExport* im = new ImportClouds();
	im->Perform();
	std::cout << "______________" << std::endl;

	osg::ref_ptr<osg::Vec3Array> vertices2;
	osg::ref_ptr<osg::Vec4Array> rotation2;
	osg::ref_ptr<osg::Vec4Array> center2; 
	osg::ref_ptr<osg::Vec4Array> ids2;
	im->GetData(0, vertices2, rotation2, center2, ids2);
	*/

	m_cloud->dBoxes_indices.resize(m_cloud->dBoxes_vertices->size());
	for(int i = 0; i < m_cloud->dBoxes_vertices->size(); i++)
	{
		m_cloud->dBoxes_indices[i] = i;
	}
	dBoxes_geometry->setVertexArray (m_cloud->dBoxes_vertices.get());
	dBoxes_geometry->addPrimitiveSet(
		new osg::DrawElementsUShort(osg::PrimitiveSet::TRIANGLES, m_cloud->dBoxes_vertices->size(), &m_cloud->dBoxes_indices[0])
	);
	dBoxes_geometry->getPrimitiveSet(0)->getDrawElements()->setDataVariance(osg::Object::DataVariance::STATIC);
	m_cloud->dBoxes->addDrawable(dBoxes_geometry.get());
	m_cloud->dBoxes->getOrCreateStateSet()->setMode(GL_CULL_FACE, osg::StateAttribute::OFF );
	m_cloud->dBoxes->setCullingActive(false);
	//dBoxes->getOrCreateStateSet()->setMode(GL_FRONT_AND_BACK, osg::PolygonMode::LINE );
#endif

	ex->AddCloud(m_cloud->GetVertices(), m_cloud->GetRotation(), m_cloud->GetCenter(), m_cloud->GetIds(), m_cloud->GetBoxCenters(), num_boxes);

}

/*void StratusGenerator::AddCloudBox(int box_iter, osg::Vec3 origin, osg::Vec3 sizes, osg::Vec3 cloud_size, osg::Vec3 jitter_sizes, bool buttom, float size_xy, osg::Vec4 min_max_scale)
{
	//Mehrere Boxen machen, dann krieg ich die Shape
	//for(int y = 0; y < sizes.y(); y++)
	for(int z = 0; z < sizes.z(); z++)
	{
		for(int y = 0; y < sizes.y(); y++)
		{
			for(int x = 0; x < sizes.x(); x++)
			{
				osg::Vec3 p = osg::Vec3(x,y,z)-(sizes/2.0);
				p = p - osg::Vec3(0.5f,0.5f,0.5f);
				p.set( p.x() * cloud_size.x(), p.y() * cloud_size.y(), p.z() * cloud_size.z());

				osg::Vec3 jitter = osg::Vec3(frand()*jitter_sizes.x(), frand()*jitter_sizes.y(), frand()*jitter_sizes.z());
				jitter = jitter - (jitter_sizes/2.0);

				osg::Vec3 pos = (origin+p+jitter);
				m_cloud->vertices->push_back(pos);
				
				//float s = frand()*150.f+0.f;
				float s = frand()*size_xy;
				float sx = s+frand()*min_max_scale.x()+min_max_scale.y();
				float sy = s+frand()*min_max_scale.z()+min_max_scale.w();
				float rot = frand()*2.f*PI;
				float cloudtype = floor(frand()*3.f)+12.f;
								
				cloudtype = (rand()%3)+12;

				osg::Vec4 geometry_infos = osg::Vec4(rot, sx, sy, 0.0);
				m_cloud->rotation->push_back(geometry_infos);

				int cloudtype2 = ((int)cloudtype+8)%16;
				osg::Vec4 cloudtypes = osg::Vec4(cloudtype, cloudtype2, 0.5, 0.0);
				m_cloud->ids->push_back(cloudtypes);

				m_cloud->center->push_back(osg::Vec4(origin.x(), origin.y(), origin.z(), 1.0));
				m_cloud->box_centers->push_back(osg::Vec4(0.f, 0.f, 0.f, box_iter));
			}
		}
	}
}*/